<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-plus-circle me-2"></i>Tambah Pengalaman Kerja
    </h2>
    <a href="<?= base_url('admin/work') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali
    </a>
</div>

<?php if (session()->getFlashdata('errors')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <form action="<?= base_url('admin/work/store') ?>" method="POST">
        <?= csrf_field() ?>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="nama_perusahaan" class="form-label">Nama Perusahaan <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nama_perusahaan" name="nama_perusahaan" 
                       value="<?= old('nama_perusahaan') ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="posisi" class="form-label">Posisi <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="posisi" name="posisi" 
                       value="<?= old('posisi') ?>" required>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label for="tahun_mulai" class="form-label">Tahun Mulai</label>
                <input type="number" class="form-control" id="tahun_mulai" name="tahun_mulai" 
                       value="<?= old('tahun_mulai') ?>" min="1900" max="2100" placeholder="Contoh: 2020">
            </div>
            <div class="col-md-3 mb-3">
                <label for="status_kerja" class="form-label">Status</label>
                <select class="form-select" id="status_kerja" name="status_kerja" onchange="toggleTahunSelesaiWork()">
                    <option value="selesai" <?= old('status_kerja', 'selesai') === 'selesai' ? 'selected' : '' ?>>Selesai</option>
                    <option value="sedang_bekerja" <?= old('status_kerja') === 'sedang_bekerja' ? 'selected' : '' ?>>Sedang Bekerja</option>
                    <option value="resign" <?= old('status_kerja') === 'resign' ? 'selected' : '' ?>>Resign</option>
                    <option value="kontrak_habis" <?= old('status_kerja') === 'kontrak_habis' ? 'selected' : '' ?>>Kontrak Habis</option>
                </select>
            </div>
            <div class="col-md-3 mb-3" id="tahun_selesai_container_work">
                <label for="tahun_selesai" class="form-label">Tahun Selesai</label>
                <input type="number" class="form-control" id="tahun_selesai" name="tahun_selesai" 
                       value="<?= old('tahun_selesai') ?>" min="1900" max="2100" placeholder="Contoh: 2023">
                <small class="text-white">Kosongkan jika sedang bekerja</small>
            </div>
            <div class="col-md-3 mb-3">
                <label for="urutan" class="form-label">
                    <i class="bi bi-sort-numeric-up me-1"></i>Urutan Tampil
                </label>
                <input type="number" class="form-control" id="urutan" name="urutan" 
                       value="<?= old('urutan', 0) ?>" min="0" max="100">
                <div class="form-text">
                    <i class="bi bi-info-circle me-1"></i>
                    <strong>Urutan tampil:</strong> 0 = paling atas
                </div>
            </div>
        </div>

        <div class="mb-3">
            <label for="deskripsi" class="form-label">
                <i class="bi bi-file-text me-1"></i>Deskripsi Pekerjaan
            </label>
            <div class="position-relative">
                <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" 
                          placeholder="Deskripsi pekerjaan akan diisi otomatis oleh AI atau Anda bisa menulis sendiri..."><?= old('deskripsi') ?></textarea>
                
                <!-- AI Generate Button -->
                <button type="button" class="btn btn-outline-primary btn-sm position-absolute ai-generate-btn" 
                        id="generateDescriptionBtn" onclick="generateWorkDescription()">
                    <i class="bi bi-magic" id="generateIcon"></i>
                    <span id="generateText">Generate AI</span>
                </button>
            </div>
            <div class="form-text">
                <i class="bi bi-lightbulb me-1 text-warning"></i>
                <strong>Tips:</strong> Isi nama perusahaan dan posisi terlebih dahulu, lalu klik "Generate AI" untuk membuat deskripsi pekerjaan otomatis.
            </div>
            
            <!-- AI Status -->
            <div id="aiStatus" class="mt-2" style="display: none;">
                <div class="alert alert-info alert-sm">
                    <i class="bi bi-robot me-1"></i>
                    <span id="aiStatusText">Sedang menggenerate deskripsi...</span>
                </div>
            </div>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i>Simpan
            </button>
            <a href="<?= base_url('admin/work') ?>" class="btn btn-secondary">
                <i class="bi bi-x me-1"></i>Batal
            </a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>


<script>
function toggleTahunSelesaiWork() {
    const status = document.getElementById('status_kerja').value;
    const tahunSelesaiContainer = document.getElementById('tahun_selesai_container_work');
    const tahunSelesaiInput = document.getElementById('tahun_selesai');
    
    if (status === 'sedang_bekerja') {
        tahunSelesaiContainer.style.opacity = '0.5';
        tahunSelesaiInput.disabled = true;
        tahunSelesaiInput.value = '';
        tahunSelesaiInput.placeholder = 'Tidak diperlukan (sedang bekerja)';
    } else {
        tahunSelesaiContainer.style.opacity = '1';
        tahunSelesaiInput.disabled = false;
        tahunSelesaiInput.placeholder = 'Contoh: 2023';
    }
}

// AI Description Generator for Work
function generateWorkDescription() {
    const namaPerusahaan = document.getElementById('nama_perusahaan').value;
    const posisi = document.getElementById('posisi').value;
    const tahunMulai = document.getElementById('tahun_mulai').value;
    const tahunSelesai = document.getElementById('tahun_selesai').value;
    
    if (!namaPerusahaan.trim()) {
        showAlert('Harap isi nama perusahaan terlebih dahulu!', 'warning');
        document.getElementById('nama_perusahaan').focus();
        return;
    }
    
    if (!posisi.trim()) {
        showAlert('Harap isi posisi pekerjaan terlebih dahulu!', 'warning');
        document.getElementById('posisi').focus();
        return;
    }
    
    // Show loading state
    const btn = document.getElementById('generateDescriptionBtn');
    const icon = document.getElementById('generateIcon');
    const text = document.getElementById('generateText');
    const status = document.getElementById('aiStatus');
    
    btn.disabled = true;
    icon.className = 'bi bi-arrow-repeat spin';
    text.textContent = 'Generating...';
    status.style.display = 'block';
    document.getElementById('aiStatusText').textContent = 'Sedang menggenerate deskripsi pekerjaan menggunakan AI...';
    
    // Prepare data
    const formData = new FormData();
    formData.append('nama_perusahaan', namaPerusahaan);
    formData.append('posisi', posisi);
    formData.append('tahun_mulai', tahunMulai);
    formData.append('tahun_selesai', tahunSelesai);
    
    // Call AI API
    fetch('<?= base_url('api/ai/generate-work') ?>', {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            document.getElementById('deskripsi').value = data.text;
            showAlert('Deskripsi pekerjaan berhasil digenerate oleh AI!', 'success');
            document.getElementById('aiStatusText').textContent = 'Deskripsi berhasil digenerate!';
            
            // Auto hide status after 3 seconds
            setTimeout(() => {
                status.style.display = 'none';
            }, 3000);
        } else {
            showAlert('Gagal generate deskripsi: ' + data.message, 'danger');
            document.getElementById('aiStatusText').textContent = 'Gagal generate: ' + data.message;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showAlert('Terjadi kesalahan saat menghubungi AI service', 'danger');
        document.getElementById('aiStatusText').textContent = 'Terjadi kesalahan koneksi';
    })
    .finally(() => {
        // Reset button state
        btn.disabled = false;
        icon.className = 'bi bi-magic';
        text.textContent = 'Generate AI';
    });
}

function showAlert(message, type) {
    // Create alert element
    const alert = document.createElement('div');
    alert.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
    alert.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    alert.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(alert);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        if (alert.parentNode) {
            alert.remove();
        }
    }, 5000);
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    toggleTahunSelesaiWork();
});
</script>
